window.template = {
	fRestrictions : [],
	init: function () {
		try {
			if (scPaLib.checkNode(".hasRemoteSections", document.body)){ // Pres with remote sections
				window.addEventListener("message", (pEvt) => {
					if (pEvt.data.action) {
						const vBd = dom.newBd(document.body);
						const vLnk = vBd.elt("a").att("href", pEvt.data.action).style("display", "none").current();
						vLnk.click();
						vLnk.parentNode.removeChild(vLnk);
					} else if (pEvt.data.getRestrictions) {
						if (template.fRestrictions.length>0) pEvt.source.postMessage({"setRestrictions": template.fRestrictions});
					}
				}, false);

				// Theme management
				const vHeadObserver = new MutationObserver(callback = (mutationList, observer) => {
					for (const mutation of mutationList) {
						if (mutation.type === "childList") {
							const vThmCss = document.head.lastElementChild;
							if (vThmCss.rel==="stylesheet"){
								vThmCss.addEventListener("load", function(pEvt){template.propagateTheme();});
								const vThmCssObserver = new MutationObserver(callback = (mutationList, observer) => {
									for (const mutation of mutationList) {
										if (mutation.type === "attributes") template.propagateTheme();
									}
								});
								vThmCssObserver.observe(vThmCss, { attributes: true, childList: false, subtree: false });
							}
						}
					}
				});
				vHeadObserver.observe(document.head, { attributes: false, childList: true, subtree: false });
				const vHtmlObserver = new MutationObserver(callback = (mutationList, observer) => {
					for (const mutation of mutationList) {
						if (mutation.type === "attributes") template.propagateFontSize();
					}
				});
				vHtmlObserver.observe(document.documentElement, { attributes: true, childList: false, subtree: false });

				this.checkRemoteSections();
			}

			if (scPaLib.checkNode(".section", document.body)){ // Remote section management
				window.addEventListener("message", (pEvt) => {
					if (pEvt.data.setRestrictions) {
						document.body.classList.add(pEvt.data.setRestrictions.join(" "))
					} else if (pEvt.data.setFontSize) {
						document.documentElement.style.fontSize = pEvt.data.setFontSize;
					} else if (pEvt.data.setTheme) {
						if (!template.fThmCss){
							const vBd = dom.newBd(document.head);
							template.fThmCss = vBd.elt("style").text(pEvt.data.setTheme).current();
						} else template.fThmCss.innerText = pEvt.data.setTheme;
					}
				}, false);

				// Restrictions
				window.parent.postMessage({"getRestrictions":true}, "*");

				// Actions
				const vActions = scPaLib.findNodes("ide:content/des:a.action");
				for (let i = 0; i < vActions.length; i++) {
					vActions[i].addEventListener("click", function (pEvt) {
						pEvt.preventDefault();
						window.parent.postMessage({"action":this.getAttribute("href")}, "*");
					})
				}
			}

			// Tab management
			const vTabLabels = scPaLib.findNodes("ide:content/des:div.tab-list/chi:label");
			const vTabPanels = scPaLib.findNodes("ide:content/des:div.tab-panels/chi:div");
			for (var i = 0; i < vTabPanels.length; i++) vTabPanels[i].fLabel = vTabLabels[i];
			const vTabInputs = scPaLib.findNodes("ide:content/des:div.tab-list/chi:input");
			for (var i = 0; i < vTabInputs.length; i++) if (vTabInputs[i].checked) {
				vTabInputs[i].onchange()
			}

			let vHash = window.location.hash;
			if (vHash.length > 0) {
				vHash = vHash.substring(1);
				const vTab = sc$("tab-" + vHash);
				if (vTab) {
					vTab.checked = true;
					this.changeTab(vTab);
				}
			}
		} catch (e) {
			scCoLib.log("ERROR template.init : " + e)
		}
	},

	checkRemoteSections: async function () {
		const vRemoteSections = scPaLib.findNodes("ide:content/des:iframe.remoteSection");
		for (let i = 0; i < vRemoteSections.length; i++) {
			try{
				if(!vRemoteSections[i].src) throw "No source";
				const vResponse = await fetch(vRemoteSections[i].src, {method: 'HEAD'});
				if (!vResponse.ok) throw "Status Code: " + vResponse.status;
			} catch (e) {
				console.log("Cannot load section '" + vRemoteSections[i].src + "' - " + e);
				vRemoteSections[i].style.display = "none";
				vRemoteSections[i].parentNode.classList.add("disconnected");
				sc$(vRemoteSections[i].parentNode.getAttribute("aria-labelledby")).classList.add("disconnected");
			}
		}
	},

	propagateFontSize: function () {
		const vRemoteSections = scPaLib.findNodes("ide:content/des:iframe.remoteSection");
		for (let i = 0; i < vRemoteSections.length; i++) {
			vRemoteSections[i].contentWindow.postMessage({"setFontSize":document.documentElement.style.fontSize}, "*");
		}
	},

	propagateTheme: async function () {
		const vThmCssElt = document.head.lastElementChild;
		if (vThmCssElt.rel === "stylesheet") {
			const vThmCssUrl = vThmCssElt.getAttribute("href");
			let vThmCssBaseUrl = vThmCssUrl.substring(0, vThmCssUrl.lastIndexOf("/"));
			let vResponse = await fetch(vThmCssUrl);
			if (vResponse.status !== 200) throw ('Cannot get theme CSS: ' + vResponse.status);
			const vThmCss = await vResponse.text();
			if (vThmCss.indexOf("basedark.css")>0) vThmCssBaseUrl += "/basedark.css";
			else if (vThmCss.indexOf("baselight.css")>0) vThmCssBaseUrl += "/baselight.css";
			vResponse = await fetch(vThmCssBaseUrl);
			if (vResponse.status !== 200) throw ('Cannot get base theme CSS: ' + vResponse.status);
			const vThmCssBase = await vResponse.text();
			const vRemoteSections = scPaLib.findNodes("ide:content/des:iframe.remoteSection");
			for (let i = 0; i < vRemoteSections.length; i++) {
				vRemoteSections[i].contentWindow.postMessage({"setTheme":vThmCssBase+vThmCss}, "*");
			}
		}
	},

	changeTab: function (pInput) {
		const vId = pInput.id.substring(4);
		const vPanels = scPaLib.findNodes("anc:.tab-box/des:.tab-content", pInput);
		for (let i = 0; i < vPanels.length; i++) {
			const vPanel = vPanels[i];
			if (!vPanel.classList.replace((vPanel.id == "panel-" + vId ? "inactive" : "active"), (vPanel.id == "panel-" + vId ? "active" : "inactive"))) {
				vPanel.classList.add((vPanel.id == "panel-" + vId ? "active" : "inactive"));
			}
			vPanel.setAttribute("aria-hidden", (vPanel.id == "panel-" + vId ? "false" : "true"));
			vPanel.fLabel.setAttribute("aria-selected", (vPanel.id == "panel-" + vId ? "true" : "false"));
		}
	},

	addRestriction: function (pRestriction) {
		document.body.classList.add(pRestriction);
		this.fRestrictions.push(pRestriction);
	}
};
